//=============================================================================
// SAN_MapGenerator_EventsCount.js
//=============================================================================
// Copyright (c) 2015-2016 Sanshiro, Machina(Altered)
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @plugindesc 自動マップ生成 ver1.15に、生成されたイベント数を設定した変数に格納する機能を追加します。
 *
 * @author サンシロ https://twitter.com/rev2nym, マキナ(Altered)
 *
 * @help
 *
 * MITライセンスのもと、商用利用、改変、再配布が可能です。
 * ただし冒頭のコメントは削除や改変をしないでください。
 * よかったらクレジットに作者名を記載してください。
 *
 * これを利用したことによるいかなる損害にも作者は責任を負いません。
 * サポートは期待しないでください＞＜。
 *
 * ///////////////////////////////////////////////////////////////////////////////
 * ■■■ Altered　16.09.18　追加 ■■■
 * 自動マップ生成 ver1.15に、生成されるモンスターの数とアイテムの数を指定した変数に代入できる機能を追加します。
 * 導入の際は、必ず自動マップ生成 ver1.15よりも下に導入して下さい。
 *
 *
 * ---使い方---
 * イベントのメモ欄に
 * <enemy><item><other1><other2><other3>
 * のいずれかを記述すると、記述されたイベントが生成された総数を
 * プラグインパラメータで設定した変数に格納する。
 * ※<enemy><other1>等、複数のタグを併記すると、記述した変数すべてでカウントされます。
 *
 *
 * ---注意事項---
 * ※本プラグインは、サンシロ様が作成された自動マップ生成 ver1.15の一部を上書きしています。
 * 　自動マップ生成プラグインのVerが1.15以外の場合、正常に動作しないことがあります。
 * 　1.15以外での動作はサポート外になります。
 * 　また、1.15のサポートにおいて、マキナ(Altered)が解決できない場合は、サポート外になります。
 * 　予めご了承下さい。
 * 　本プラグインは、自動マップ生成 ver1.13から同機能を抜き出した内容になります。
 * ※本プラグインは、MITライセンスのもと、商用利用、改変、再配布が可能ですが、自動マップ生成 ver1.15のライセンスも厳守して下さい。
 *
 * 素晴らしいプラグインを作成されたサンシロ様に、感謝を込めて。
 *
 * ///////////////////////////////////////////////////////////////////////////////
 *
 *
 * @param EnemyCount
 * @desc メモ欄に<enemy>と記述したイベントの生成数カウントを
 * 代入する変数の番号です。マップを再生成すると上書きされます。
 * @default 2
 *
 * @param ItemCount
 * @desc メモ欄に<item>と記述したイベントの生成数カウントを
 * 代入する変数の番号です。マップを再生成すると上書きされます。
 * @default 3
 *
 * @param Other1Count
 * @desc メモ欄に<other1>と記述したイベントの生成数カウントを
 * 代入する変数の番号です。マップを再生成すると上書きされます。
 * @default 4
 *
 * @param Other2Count
 * @desc メモ欄に<other2>と記述したイベントの生成数カウントを
 * 代入する変数の番号です。マップを再生成すると上書きされます。
 * @default 5
 *
 * @param Other3Count
 * @desc メモ欄に<other3>と記述したイベントの生成数カウントを
 * 代入する変数の番号です。マップを再生成すると上書きされます。
 * @default 6
 */

 // 確率イベントの設置
 Game_MapGenerator.prototype.setRateEvents = function() {

     //Altered:追記箇所
     var mapDataEnemyEvents = $dataMap.events.filter(function(event) {
         return !!event && !!event.meta.enemy;
     });
     var mapDateEnemyIdArray = [];
     for (var i = 0; i < mapDataEnemyEvents.length; i++) {
       if (mapDataEnemyEvents[i].meta.enemy) {
         mapDateEnemyIdArray[i] = mapDataEnemyEvents[i].id;
       }
     }

     var mapDataItemEvents = $dataMap.events.filter(function(event) {
         return !!event && !!event.meta.item;
     });
     var mapDateItemIdArray = [];
     for (var i = 0; i < mapDataItemEvents.length; i++) {
       if (mapDataItemEvents[i].meta.item) {
         mapDateItemIdArray[i] = mapDataItemEvents[i].id;
       }
     }

     var mapDataother1Events = $dataMap.events.filter(function(event) {
         return !!event && !!event.meta.other1;
     });
     var mapDateother1IdArray = [];
     for (var i = 0; i < mapDataother1Events.length; i++) {
       if (mapDataother1Events[i].meta.other1) {
         mapDateother1IdArray[i] = mapDataother1Events[i].id;
       }
     }

     var mapDataother2Events = $dataMap.events.filter(function(event) {
         return !!event && !!event.meta.other2;
     });
     var mapDateother2IdArray = [];
     for (var i = 0; i < mapDataother2Events.length; i++) {
       if (mapDataother2Events[i].meta.other2) {
         mapDateother2IdArray[i] = mapDataother2Events[i].id;
       }
     }

     var mapDataother3Events = $dataMap.events.filter(function(event) {
         return !!event && !!event.meta.other3;
     });
     var mapDateother3IdArray = [];
     for (var i = 0; i < mapDataother3Events.length; i++) {
       if (mapDataother3Events[i].meta.other3) {
         mapDateother3IdArray[i] = mapDataother3Events[i].id;
       }
     }
     console.log(mapDateEnemyIdArray);
     console.log(mapDateItemIdArray);
     console.log(mapDateother1IdArray);
     console.log(mapDateother2IdArray);
     console.log(mapDateother3IdArray);
     //Altered:追記箇所ここまで


     var mapDataRateMapEvents = $dataMap.events.filter(function(event) {
         return !!event && !!event.meta.RateMap;
     });
     mapDataRateMapEvents.forEach(function(mapDataEvent) {
         if (this.randBool(parseFloat(mapDataEvent.meta.RateMap))) {
             var event = new Game_Event($gameMap.mapId(), mapDataEvent.id);
             this.setEvent(event);
         }
     }, this);
     var mapDataRateRoomEvents = $dataMap.events.filter(function(event) {
         return !!event && !!event.meta.RateRoom;
     });
     mapDataRateRoomEvents.forEach(function(mapDataEvent) {
         this._rooms.forEach(function(room) {
             if (this.randBool(parseFloat(mapDataEvent.meta.RateRoom))) {
                 var event = new Game_Event($gameMap.mapId(), mapDataEvent.id);
                 this.setEvent(event, 'room', room);
             }
         }, this);
     }, this);

     //Altered:追記箇所
     var mapEnemyCount=0, mapItemCount=0, mapother1Count=0, mapother2Count=0, mapother3Count=0;
     for (var i = 0; i < $gameMap._events.length; i++) {

       for (var i2 = 0; i2 < mapDateEnemyIdArray.length; i2++) {
         if ($gameMap._events[i]._dataEventId == mapDateEnemyIdArray[i2]) {
           mapEnemyCount++
         }
       }

       for (var i2 = 0; i2 < mapDateItemIdArray.length; i2++) {
         if ($gameMap._events[i]._dataEventId == mapDateItemIdArray[i2]) {
           mapItemCount++
         }
       }

       for (var i2 = 0; i2 < mapDateother1IdArray.length; i2++) {
         if ($gameMap._events[i]._dataEventId == mapDateother1IdArray[i2]) {
           mapother1Count++
         }
       }

       for (var i2 = 0; i2 < mapDateother2IdArray.length; i2++) {
         if ($gameMap._events[i]._dataEventId == mapDateother2IdArray[i2]) {
           mapother2Count++
         }
       }

       for (var i2 = 0; i2 < mapDateother3IdArray.length; i2++) {
         if ($gameMap._events[i]._dataEventId == mapDateother3IdArray[i2]) {
           mapother3Count++
         }
       }
     }

     $gameVariables.setValue(Number(PluginManager.parameters('SAN_MapGenerator_EventsCount')['EnemyCount']), mapEnemyCount);
     $gameVariables.setValue(Number(PluginManager.parameters('SAN_MapGenerator_EventsCount')['ItemCount']), mapItemCount);
     $gameVariables.setValue(Number(PluginManager.parameters('SAN_MapGenerator_EventsCount')['Other1Count']), mapother1Count);
     $gameVariables.setValue(Number(PluginManager.parameters('SAN_MapGenerator_EventsCount')['Other2Count']), mapother2Count);
     $gameVariables.setValue(Number(PluginManager.parameters('SAN_MapGenerator_EventsCount')['Other3Count']), mapother3Count);
     //Altered:追記箇所ここまで
 };
